﻿using System;
using gov.va.med.vbecs.Common;

namespace VBECS.Services.Common.AppServices
{
    /// <summary>
    /// The Global context exposes classes and data that can be used by our server components, 
    /// they are request agnostic and are kept alive along with the application. 
    /// A good approach with these global resources and services is not keeping any sort of state if feasible, 
    /// concurrency issues may arise if the design is not correct.
    /// 
    /// Multithreaded Singleton.Double-Check Locking pattern is used.
    /// </summary>
    public class GlobalContext
    {
        static readonly Object LocatorLock = new object();
        private static volatile GlobalContext _internalInstance;

        /// <summary>
        /// Constructor
        /// </summary>
        protected GlobalContext() { }

        /// <summary>
        /// Returns instance of GlobalContext
        /// </summary>
        /// <returns></returns>
        public static GlobalContext Instance()
        {
            if (_internalInstance != null) return _internalInstance;

            lock (LocatorLock)
            {
                // in case of a race scenario ... check again
                if (_internalInstance == null)
                {
                    _internalInstance = new GlobalContext();
                }
            }
            return _internalInstance;
        }

        #region IGlobalContext Members

// ReSharper disable UnusedAutoPropertyAccessor.Local
        /// <summary>
        /// Returns services properties
        /// </summary>
        public ServiceProperties ServiceProperties { get; private set; }

        /// <summary>
        /// Returns server object
        /// </summary>
        public IServer Server { get; private set; }
// ReSharper restore UnusedAutoPropertyAccessor.Local

        #endregion
    }

}
